-- World of Warcraft Addon
-- TargetNotes
-- author:  Tokipin@Mannoroth
-- 
-- database

--function print( str, ... )
--    UIErrorsFrame:AddMessage( tostring( str ), ... );
--    DEFAULT_CHAT_FRAME:AddMessage( tostring( str ), ... );
--end

TARGETNOTES_SETTINGS = TARGETNOTES_SETTINGS or {};
TARGETNOTES_SETTINGS["definition of word"] = "[^%s]+";

TARGETNOTES_FUNCTIONS = TARGETNOTES_FUNCTIONS or {};

-- [[ db interface constructor thingie ]] --
TARGETNOTES_FUNCTIONS["CreateDB"] = function( na ) -- named arguments
    local DB = na["content database"];
    local IX = na["index database"];
    local min_prefix_length = na["minimum prefix length"] or 3;
    local case_sensitive = na["case sensitive?"];
    local store = na["storage function"] or function(...) return ... end;
    local extract = na["extraction function"] or function(...) return ... end;

    local word_def = TARGETNOTES_SETTINGS["definition of word"];

    local obj = {};

    --[[ ## text iterators ## ]]--

    -- words from tables
    local words = function( tbl )
        return coroutine.wrap( function()
            local function extract_words( item )
                if( type( item ) == "table" ) then
                    for key, value in pairs( item ) do
                        extract_words( value );
                    end
                else
                    for word in string.gmatch( tostring( item ), word_def ) do
                        coroutine.yield( word );
                    end
                end
            end

            extract_words( tbl );
        end );
    end

    -- prefixes from words
    local prefixes = function( word, min_length )
        return coroutine.wrap( function()
            for i = min_length, #word do
                coroutine.yield( string.sub( word, 1, i ) );
            end
        end );
    end

    --[[ ## database logic ## ]]--

    local indexing_algorithm = function( id, tbl )
        for word in words( tbl ) do
            word = case_sensitive and word or string.lower( word );
            for prefix in prefixes( word, min_prefix_length ) do
                if( IX[prefix] ) then -- entry for this prefix already exists
                    table.insert( IX[prefix], id );
                else
                    IX[prefix] = { id }; -- create entry for this prefix
                end
            end
        end
    end

    local unindexing_algorithm = function( id, tbl )
        for word in words( tbl ) do
            word = case_sensitive and word or string.lower( word );
            for prefix in prefixes( word, min_prefix_length ) do
                for key, value in pairs( IX[prefix] ) do
                    if( value == id ) then -- this prefix has a pointer to the id
                        table.remove( IX[prefix], key ); -- remove the pointer
                        if( #IX[prefix] == 0 ) then
                            IX[prefix] = nil;
                        end
                        break;
                    end
                end
            end
        end
    end

    local searching_algorithm = function( search_string )
        local ranks = {};

        for word in words( search_string ) do
            word = case_sensitive and word or string.lower( word );
            if( IX[word] ) then -- this word points to id(s)
                for key, value in pairs( IX[word] ) do
                    if( ranks[value] ) then
                        ranks[value] = ranks[value] + 1;
                    else
                        ranks[value] = 1;
                    end
                end
            end
        end

        return ranks;
    end

    --[[ ## object publics ## ]]--

    -- usage: AddEntry( value ) to append or AddEntry( id, value ) to overwrite
    function obj:AddEntry( arg1, arg2 )
        local id, value;

        if( arg2 ) then
            id, value = arg1, arg2;
            DB[id] = store( value );
        else
            value = arg1;
            table.insert( DB, store( value ) );
            id = #DB;
        end

        indexing_algorithm( id, value );
    end

    function obj:RemoveEntry( id )
        unindexing_algorithm( id, extract( DB[id] ) );
        DB[id] = {};
    end

    function obj:GetEntry( id )
        return extract( DB[id] );
    end

    function obj:Search( search_string )
        local ranks = searching_algorithm( search_string );

        local collection = {};
        for id, rank in pairs( ranks ) do
            table.insert( collection, { entry = extract( DB[id] ), rank = rank, id = id } );
        end

        return collection;
    end

    function obj:Find( search_string, on_value )
        local ranks = searching_algorithm( search_string );

        for key in pairs( ranks ) do
            if( on_value( extract( DB[key] ) ) ) then
                return key;
            end
        end
    end

    return obj; -- return
end
